/*
	LUSScreenSaver Plugin Interface
	Copyright (C) 2003 ONO,Masayuki.<mono101@skill-engineering.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "../LUSScreenSaver/LUSScreenSaverInterface.h"
#include "../LUSScreenSaver/LUSScreenSaverMisc.h"
#include "LUSScreenSaverUtil.h"

#include <qtabwidget.h>
#include <qcombobox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qmultilineedit.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qcheckbox.h>
#include <qslider.h>
#include <qfile.h>
#include <qdir.h>
#include <qmessagebox.h>
#include <qpe/qlibrary.h>
#include <qpe/resource.h>
#include <qpe/config.h>

#include <qtextcodec.h>
#define _T(str) QTextCodec::codecForLocale()->toUnicode(str)

using namespace LUSMisc;

LUSScreenSaverUtil::LUSScreenSaverUtil( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : LUSScreenSaverUtilBase( parent, name, modal, fl ), m_pSaver( NULL )
{
	setWState( WState_Reserved1 );
	Tabs->setTabEnabled( Tab2, FALSE );
	m_sNone = tr( " ( none ) " );

	LoadModuleList();

	if ( GetIconMode() == 1 )
	{
		TrayIconCheck->setChecked( TRUE );
	}

	connect( Tabs, SIGNAL( currentChanged( QWidget* ) ),
				this, SLOT( changedTabs( QWidget* ) ) );
	connect( ModuleSelectCombo, SIGNAL( activated(const QString&) ),
				this, SLOT( moduleChanged(const QString&) ) );
	connect( IntervalSlider, SIGNAL( valueChanged( int ) ),
				this, SLOT( setSliderLabel( int ) ) );
	connect( SettingButton, SIGNAL( clicked() ), this, SLOT( DoSetting() ) );
	QTimer::singleShot( 1000, this, SLOT( FirstLoad() ) );

	Config cfg( "qpe" );
	cfg.setGroup( "Screensaver" );
	IntervalSlider->setValue( cfg.readNumEntry( "Interval_AC_ScreenSaver", 300 ) / 60 );
}

LUSScreenSaverUtil::~LUSScreenSaverUtil()
{
	delete m_pSaver;
}

void LUSScreenSaverUtil::resizeEvent( QResizeEvent* )
{	
	Tabs->showPage( Tab1 );

	int nWidth = QPEApplication::desktop()->width();
	int nHeight = QPEApplication::desktop()->height();

	PreviewWindow->setMinimumSize( QSize( nWidth / 2, nHeight / 2 ) );
	PreviewWindow->setMaximumSize( QSize( nWidth / 2, nHeight / 2 ) );
}

void LUSScreenSaverUtil::FirstLoad()
{
	moduleChanged( ModuleSelectCombo->currentText() );
}

void LUSScreenSaverUtil::LoadModuleList()
{

	ModuleSelectCombo->insertItem( m_sNone );

    QDir appletDir;
    QString dirPath;

    dirPath = QPEApplication::qpeDir();
    dirPath.append( "plugins/screensaver" );

    appletDir = QDir( dirPath );
    appletDir.setFilter( QDir::Files|QDir::Hidden );
    appletDir.setNameFilter( "*.so" );

    const QFileInfoList *appletList = appletDir.entryInfoList();
    QFileInfoListIterator appletIterator( *appletList );
    QFileInfo *appletInfo;

	while ( ( appletInfo = appletIterator.current() ) )
	{
		QString direntName = appletInfo->fileName();
		direntName = direntName.left( direntName.length() - 3 );
		direntName = direntName.mid( 3 );
		ModuleSelectCombo->insertItem( direntName );
		++ appletIterator;
	}
	
	QString sCurrentModule = GetSaverName();
	for ( int nCnt = 0; nCnt < ModuleSelectCombo->count(); nCnt ++ )
	{
		if ( ModuleSelectCombo->text( nCnt ) == sCurrentModule )
		{
			ModuleSelectCombo->setCurrentItem( nCnt );
			break;
		}
	}
}

void LUSScreenSaverUtil::DoSetting()
{
	if ( m_pSaver )
	{
	    LUSScreenSaverInterface* iface;
	    if ( m_pSaver->queryInterface( IID_LUSScreenSaver, (QUnknownInterface**)&iface ) == QS_OK )
		{
			iface->Setting();
		}
	}
	StopSaver();
	StartSaver();
}

void LUSScreenSaverUtil::moduleChanged( const QString& moduleName )
{
	if ( m_pSaver )
	{
		m_pSaver->unload();
		delete m_pSaver;
		m_pSaver = NULL;
	}

	if ( moduleName == m_sNone )
	{
		PropertyDisplay->setText( QString::null );
		Tabs->setTabEnabled( Tab2, FALSE );
		return;
	}
	
	QString sSaverPath = AbsSaverPath( moduleName );
	m_pSaver = new QLibrary( sSaverPath, QLibrary::Immediately );

    LUSScreenSaverInterface* iface;
    if ( m_pSaver->queryInterface( IID_LUSScreenSaver, (QUnknownInterface**)&iface ) != QS_OK )
	{
		// NOT SAVER
		ModuleSelectCombo->setCurrentItem( 0 );
		PropertyDisplay->setText( QString::null );
		Tabs->setTabEnabled( Tab2, FALSE );
		
		QMessageBox mb( "LUSScreenSaverUtil",
						tr( "Selected is not\n a Screen Saver !!" ),
						QMessageBox::NoIcon,
						QMessageBox::Ok,
						QMessageBox::NoButton, QMessageBox::NoButton, this );
		mb.setIconPixmap( Resource::loadPixmap( "LUSScreenSaver_about" ) );
		mb.adjustSize();
		mb.exec();
		return;
	}
	
	Tabs->setTabEnabled( Tab2, TRUE );
	SettingButton->setEnabled( iface->CanCustomize() );

	QString sDisp = QString( "NAME : %1\nVER. : %1\nCOMMENT :" )
					.arg( iface->Name() )
					.arg( iface->Version() );
	PropertyDisplay->setText( sDisp );
	PropertyDisplay->append( iface->Comment() );
}

void LUSScreenSaverUtil::changedTabs( QWidget* )
{
	if ( Tabs->currentPage() == Tab2 )
	{
		StartSaver();
	}
	else
	{
		StopSaver();
	}
}

void LUSScreenSaverUtil::StartSaver()
{
	if ( m_pSaver )
	{
    	LUSScreenSaverInterface* iface;
    	if ( m_pSaver->queryInterface( IID_LUSScreenSaver, (QUnknownInterface**)&iface ) == QS_OK )
		{
			QWidget* pSaverWidget = iface->Init( LUSScreenSaverInterface::LUS_PREVIEW );

			if ( pSaverWidget )
			{
				pSaverWidget->reparent( Tab2, QPoint( PreviewWindow->x(), PreviewWindow->y() ), TRUE );
				pSaverWidget->resize( PreviewWindow->size() );
				pSaverWidget->setGeometry( PreviewWindow->geometry() );
				iface->Start();
			}
		}
	}
}

void LUSScreenSaverUtil::StopSaver()
{
	if ( m_pSaver )
	{
    	LUSScreenSaverInterface* iface;
    	if ( m_pSaver->queryInterface( IID_LUSScreenSaver, (QUnknownInterface**)&iface ) == QS_OK )
		{
			iface->Stop();
		}
	}
}

void LUSScreenSaverUtil::setSliderLabel( int value )
{
	QString labelText( tr( "Screensaver Interval : " ) );
	labelText += QString( "%1" ).arg( value );
	labelText += tr( " min." );
	SliderLabel->setText( labelText );
}

void LUSScreenSaverUtil::closeEvent( QCloseEvent *e )
{
	if ( m_pSaver )
	{
	    LUSScreenSaverInterface* iface;
	    if ( m_pSaver->queryInterface( IID_LUSScreenSaver, (QUnknownInterface**)&iface ) == QS_OK )
		{
			iface->Stop();
		}
		m_pSaver->unload();
		delete m_pSaver;
		m_pSaver = NULL;
	}

	e->accept();
}

void LUSScreenSaverUtil::accept()
{
	Config cfg( "LUSScreenSaver" );
	cfg.setGroup( "Screensaver" );
	QString sModule = ModuleSelectCombo->currentText();
	if ( sModule == m_sNone )
	{
		sModule = QString::null;
	}
	cfg.writeEntry( "Module", sModule );

	QCopEnvelope e( "QPE/LUSScreenSaver", "ShowIcon(int)" );
	e << ( TrayIconCheck->isChecked() ? 1 : 0 );

	Config cfg_qpe( "qpe" );
	cfg_qpe.setGroup( "Screensaver" ); 
	cfg_qpe.writeEntry( "Interval_AC_ScreenSaver", IntervalSlider->value() * 60 );

	close();
}

void LUSScreenSaverUtil::reject()
{
/*
	QMessageBox mb( "LUSScreenSaverUtil",
					"reject()",
					QMessageBox::NoIcon,
					QMessageBox::Ok,
					QMessageBox::NoButton, QMessageBox::NoButton, this );
	mb.setIconPixmap( Resource::loadPixmap( "LUSScreenSaver_about" ) );
	mb.adjustSize();
	mb.exec();
*/
	close();
}

