/*
	LUSScreenSaver Plugin Interface
	Copyright (C) 2003 ONO,Masayuki.<mono101@skill-engineering.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __LESS_UnSatICEFACTORY_SCREENSAVER_UTIL_H__
#define __LESS_UnSatICEFACTORY_SCREENSAVER_UTIL_H__

#include <qvariant.h>
#include <qdialog.h>
#include "LUSScreenSaverUtilBase.h"

class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QComboBox;
class QGroupBox;
class QLabel;
class QMultiLineEdit;
class QPushButton;
class QLibrary;

class LUSScreenSaverUtil : public LUSScreenSaverUtilBase
{ 
    Q_OBJECT

public:
    LUSScreenSaverUtil( QWidget* parent = 0, const char* name = 0,
    						bool modal = FALSE, WFlags fl = 0 );
    ~LUSScreenSaverUtil();

private:
	void LoadModuleList();
	QLibrary* m_pSaver;
	QString m_sNone;

protected slots:
	void setSliderLabel( int );
	void changedTabs( QWidget* );
	void StartSaver();
	void StopSaver();
	void FirstLoad();
	void DoSetting();
	void resizeEvent( QResizeEvent* );
	void moduleChanged( const QString& );
	void closeEvent( QCloseEvent* );
	void accept();
	void reject();
};

#endif // __LESS_UnSatICEFACTORY_SCREENSAVER_UTIL_H__
