/*
	LUSScreenSaverUtil
	Copyright (C) 2003 ONO,Masayuki.<mono101@skill-engineering.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "LUSScreenSaverUtilBase.h"

#include <qtabwidget.h>
#include <qcombobox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qmultilineedit.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qslider.h>
#include <qcheckbox.h>
#include <qpe/resource.h>
static const char* _version_ =
#include "./version.txt"
;

LUSScreenSaverUtilBase::LUSScreenSaverUtilBase( QWidget* parent,  const char* name,
																bool modal, WFlags fl )
: QDialog( parent, name, modal, fl )
{
	if ( !name )
	setName( "LUSScreenSaverUtil" );
	resize( 553, 263 ); 
	setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)5,
												sizePolicy().hasHeightForWidth() ) );
	QString caption;
	caption = tr( "LUSScreenSaverUtil" );
	caption += " Ver.";
	caption += _version_;
	setCaption( caption );

	BaseFormLayout = new QVBoxLayout( this ); 
	BaseFormLayout->setSpacing( 6 );
	BaseFormLayout->setMargin( 11 );

	Tabs = new QTabWidget( this, "Tabs" );
	BaseFormLayout->addWidget( Tabs );

	Tab1 = new QWidget( Tabs );
	TabBaseLayout1 = new QVBoxLayout( Tab1 ); 
	TabBaseLayout1->setSpacing( 6 );
	TabBaseLayout1->setMargin( 11 );

	BasicGroupBox = new QGroupBox( Tab1, "BasicGroupBox" );
	BasicGroupBox->setTitle( "" );
	BasicGroupBox->setColumnLayout(0, Qt::Vertical );
	BasicGroupBox->layout()->setSpacing( 0 );
	BasicGroupBox->layout()->setMargin( 0 );
	BasicGroupBoxLayout = new QVBoxLayout( BasicGroupBox->layout() );
	BasicGroupBoxLayout->setAlignment( Qt::AlignTop );
	BasicGroupBoxLayout->setSpacing( 6 );
	BasicGroupBoxLayout->setMargin( 11 );
	
	TrayIconCheck = new QCheckBox( tr( "ShowTrayIcon" ), BasicGroupBox, "TrayIconCheck" );

	SliderLabel = new QLabel( tr( "Interval" ), BasicGroupBox, "SliderLabel" );

	IntervalSlider = new QSlider( 5, 30, 1, 5, QSlider::Horizontal, BasicGroupBox );
	IntervalSlider->setTickInterval( 1 );
	IntervalSlider->setPageStep( 5 );
	IntervalSlider->setLineStep( 1 );
	IntervalSlider->setTracking( TRUE );
	IntervalSlider->setTickmarks( QSlider::NoMarks );

	DisSuspendLabel = new QLabel( tr("Prosecces to Disable Suspend"), BasicGroupBox, "DisSuspendLabel" );
	DisSuspendApp = new QLineEdit( BasicGroupBox, "DisSuspendApp" );

	DisScreenSavingLabel = new QLabel( tr("Processes to Disable ScreenSaving"), BasicGroupBox, "DisScreenSavingLabel" );
	DisScreenSavingApp = new QLineEdit( BasicGroupBox, "DisScreenSavingApp" );

	BasicGroupBoxLayout->addWidget( TrayIconCheck );
	BasicGroupBoxLayout->addWidget( SliderLabel );
	BasicGroupBoxLayout->addWidget( IntervalSlider );
	BasicGroupBoxLayout->addWidget( DisScreenSavingLabel );
	BasicGroupBoxLayout->addWidget( DisScreenSavingApp );
	BasicGroupBoxLayout->addWidget( DisSuspendLabel );
	BasicGroupBoxLayout->addWidget( DisSuspendApp );

	TabBaseLayout1->addWidget( BasicGroupBox );
	
	Tabs->addTab( Tab1, tr( "General" ) );

	Tab3 = new QWidget( Tabs );
	TabBaseLayout3 = new QVBoxLayout( Tab3 ); 
	TabBaseLayout3->setSpacing( 6 );
	TabBaseLayout3->setMargin( 11 );
	ModuleGroupBox = new QGroupBox( Tab3, "ModuleGroupBox" );
	ModuleGroupBox->setTitle("");
	ModuleGroupBox->setColumnLayout(0, Qt::Vertical );
	ModuleGroupBox->layout()->setSpacing( 0 );
	ModuleGroupBox->layout()->setMargin( 0 );
	ModuleGroupBoxLayout = new QVBoxLayout( ModuleGroupBox->layout() );
	ModuleGroupBoxLayout->setAlignment( Qt::AlignTop );
	ModuleGroupBoxLayout->setSpacing( 6 );
	ModuleGroupBoxLayout->setMargin( 11 );
	ModuleSelectCombo = new QComboBox( FALSE, ModuleGroupBox, "ModuleSelectCombo" );
	ModuleGroupBoxLayout->addWidget( ModuleSelectCombo );
	SettingButton = new QPushButton( ModuleGroupBox, "SettingButton" );
	SettingButton->setText( tr( "settings" ) );
	ModuleGroupBoxLayout->addWidget( SettingButton );
	PropertyDisplay = new QMultiLineEdit( ModuleGroupBox, "PropertyDisplay" );
	PropertyDisplay->setReadOnly( TRUE );
	ModuleGroupBoxLayout->addWidget( PropertyDisplay );
	TabBaseLayout3->addWidget( ModuleGroupBox );

	Tabs->addTab( Tab3, tr( "Module" ) );

	Tab2 = new QWidget( Tabs );
	TabBaseLayout2 = new QVBoxLayout( Tab2 ); 
	TabBaseLayout2->setSpacing( 6 );
	TabBaseLayout2->setMargin( 11 );

	PreviewWindow = new QLabel( Tab2, "PreviewWindow" );
	PreviewWindow->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0,
												(QSizePolicy::SizeType)0,
										PreviewWindow->sizePolicy().hasHeightForWidth() ) );
	PreviewWindow->setMinimumSize( QSize( 320, 240 ) );
	PreviewWindow->setMaximumSize( QSize( 320, 240 ) );
	QPixmap image0;
	image0.resize( 320, 240 );
	image0.fill( QColor(0,0,0) );
	PreviewWindow->setPixmap( image0 );
	PreviewWindow->setScaledContents( TRUE );
	TabBaseLayout2->addWidget( PreviewWindow );

	Tabs->addTab( Tab2, tr( "Preview" ) );
}

LUSScreenSaverUtilBase::~LUSScreenSaverUtilBase()
{
	// no need to delete child widgets, Qt does it all for us
}

